package gov.va.genisis2.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class RequestHistory.
 * 
 * Description: In this RequestHistory Class implements the interface
 * Serializable and defines the entity and data mapping for the
 * dbo.User_Approver Table in the database.
 */
@Entity
@Table(name = "RequestHistory", schema = "dbo")
@JsonIgnoreProperties({ "request" })
public class RequestHistory implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -3025948940261885259L;
	private int histLineNo;
	private Request request;
	private int processId;
	private String title;
	private String description;
	private String statusDescription;
	private int requestTypeId;
	private int sourceId;
	private int studyApprovalId;
	private Date createdOn;
	private Date modifiedOn;
	private String createdBy;
	private String modifiedBy;
	private String approverId;
	private String taskId;

	public RequestHistory() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * @param histLineNo
	 *            History Line primary key
	 * @param request
	 *            The Request
	 * @param processId
	 *            The workflow process Id
	 * @param title
	 *            The Title
	 * @param description
	 *            The Description
	 * @param statusDescription
	 *            The workflow status of this Request
	 * @param requestTypeId
	 *            The Request Type Id
	 * @param sourceId
	 *            The source Id
	 * @param studyApprovalId
	 *            The approval Study Id
	 * @param createdOn
	 *            Request creation date
	 * @param modifiedOn
	 *            Request modification date
	 * @param createdBy
	 *            Requested Created by
	 * @param modifiedBy
	 *            Request Modified by
	 * @param approverId
	 *            Request approver Id
	 * @param taskId
	 *            Request Task Id to link Comment
	 */
	public RequestHistory(int histLineNo, Request request, int processId, String title, String description,
			String statusDescription, int requestTypeId, int sourceId, int studyApprovalId, Date createdOn,
			Date modifiedOn, String createdBy, String modifiedBy, String approverId, String taskId) {
		this.histLineNo = histLineNo;
		this.request = request;
		this.processId = processId;
		this.title = title;
		this.description = description;
		this.statusDescription = statusDescription;
		this.requestTypeId = requestTypeId;
		this.sourceId = sourceId;
		this.studyApprovalId = studyApprovalId;
		this.createdOn = createdOn;
		this.modifiedOn = modifiedOn;
		this.createdBy = createdBy;
		this.modifiedBy = modifiedBy;
		this.approverId = approverId;
		this.taskId = taskId;
	}

	@Id
	@Column(name = "HistLineNo", unique = true, nullable = false)
	public int getHistLineNo() {
		return this.histLineNo;
	}

	public void setHistLineNo(int histLineNo) {
		this.histLineNo = histLineNo;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "Id", nullable = false)
	public Request getRequest() {
		return this.request;
	}

	public void setRequest(Request request) {
		this.request = request;
	}

	@Column(name = "ProcessId", nullable = false)
	public int getProcessId() {
		return this.processId;
	}

	public void setProcessId(int processId) {
		this.processId = processId;
	}

	@Column(name = "Title", length = 256)
	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "Description", length = 3000)
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "StatusDescription", length = 50)
	public String getStatusDescription() {
		return this.statusDescription;
	}

	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	@Column(name = "RequestTypeId", nullable = false)
	public int getRequestTypeId() {
		return this.requestTypeId;
	}

	public void setRequestTypeId(int requestTypeId) {
		this.requestTypeId = requestTypeId;
	}

	@Column(name = "SourceId", nullable = false)
	public int getSourceId() {
		return this.sourceId;
	}

	public void setSourceId(int sourceId) {
		this.sourceId = sourceId;
	}

	@Column(name = "StudyApprovalId", nullable = false)
	public int getStudyApprovalId() {
		return this.studyApprovalId;
	}

	public void setStudyApprovalId(int studyApprovalId) {
		this.studyApprovalId = studyApprovalId;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	public Date getCreatedOn() {
		return this.createdOn;
	}

	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	@Column(name = "CreatedBy", length = 50)
	public String getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "ModifiedBy", length = 50)
	public String getModifiedBy() {
		return this.modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Column(name = "ApproverId", length = 50)
	public String getApproverId() {
		return this.approverId;
	}

	public void setApproverId(String approverId) {
		this.approverId = approverId;
	}

	@Column(name = "TaskId", length = 50)
	public String getTaskId() {
		return this.taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
}
